; Script generated by the HM NIS Edit Script Wizard.

BGGradient 000000 FEF42 FFFFFF
XPStyle on

;; These are set to default values (NSIS v2.02) so we
;; probably don't need them.
SetDateSave on
SetDatablockOptimize on
CRCCheck on
SilentInstall normal


; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "Headless iPodder"
!define PRODUCT_VERSION "2.1.1"
!define PRODUCT_PUBLISHER "iPodder Team"
!define PRODUCT_WEB_SITE "http://ipodder.sourceforge.net/"
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\hiPodder.exe"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "C:\cygwin\home\aegrumet\iSpider\icons_status\hiPodder.ico"
!define MUI_UNICON "C:\cygwin\home\aegrumet\iSpider\icons_status\hiPodder.ico"

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; License page
!insertmacro MUI_PAGE_LICENSE "..\gpl.txt"
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Components page
!insertmacro MUI_PAGE_COMPONENTS
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!define MUI_FINISHPAGE_RUN "$INSTDIR\hiPodder.exe"
!define MUI_FINISHPAGE_SHOWREADME "$INSTDIR\readme.txt"
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "hiPodder211Setup.exe"
InstallDir "$PROGRAMFILES\hiPodder"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""
ShowInstDetails show
ShowUnInstDetails show

Section "-hiPodder" SEC01
  FindProcDLL::FindProc "hiPodder.exe"
  StrCmp $R0 "0" readytowrite

  concurrentproc:

  MessageBox MB_RETRYCANCEL "Another copy of headless iPodder is running.  Please quit headless iPodder before continuing by right-clicking on the application icon in the system tray and selecting Quit." IDCANCEL cancel


  FindProcDLL::FindProc "hiPodder.exe"
  StrCmp $R0 "1" concurrentproc
  StrCmp $R0 "0" readytowrite

  cancel:

  Abort "Can't install"

  readytowrite:

  SetOutPath "$INSTDIR"
  SetOverwrite off
  File "..\dist\favorites.txt"
  SetOverwrite ifnewer
  File "..\dist\datetime.pyd"
  File "..\dist\gpl.txt"
  SetOverwrite on
  File "..\dist\hiPodder.exe"
  File "..\dist\hiPodder.exe.manifest"
  File "..\dist\library.zip"
  File "..\dist\pyexpat.pyd"
  File "..\dist\python23.dll"
  File "..\dist\pythoncom23.dll"
  File "..\dist\pywintypes23.dll"
  File "..\dist\readme.txt"
  File "..\dist\select.pyd"
  File "..\dist\timer.pyd"
  File "..\dist\unicodedata.pyd"
  File "..\dist\w9xpopen.exe"
  File "..\dist\win32api.pyd"
  File "..\dist\win32evtlog.pyd"
  File "..\dist\win32file.pyd"
  File "..\dist\win32gui.pyd"
  File "..\dist\win32pipe.pyd"
  File "..\dist\win32ui.pyd"
  File "..\dist\zlib.pyd"
  File "..\dist\_bsddb.pyd"
  File "..\dist\_socket.pyd"
  File "..\dist\_sre.pyd"
  File "..\dist\_ssl.pyd"
  File "..\dist\_winreg.pyd"
  SetOutPath "$INSTDIR\icons_status"
  File "..\dist\icons_status\hiPodder.ico"
  File "..\dist\icons_status\hiPodder_running.ico"
  CreateDirectory "$SMPROGRAMS\hiPodder"
  CreateShortCut "$SMPROGRAMS\hiPodder\hiPodder.lnk" "$INSTDIR\hiPodder.exe"
SectionEnd

Section "Desktop shortcut"
  CreateShortCut "$DESKTOP\hiPodder.lnk" "$INSTDIR\hiPodder.exe"
SectionEnd

Section /o "Add to Startup Group"
  CreateShortCut "$SMSTARTUP\hiPodder.lnk" "$INSTDIR\hiPodder.exe"
SectionEnd

Section -AdditionalIcons
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  CreateShortCut "$SMPROGRAMS\iPodder\Website.lnk" "$INSTDIR\${PRODUCT_NAME}.url"
  CreateShortCut "$SMPROGRAMS\iPodder\Uninstall.lnk" "$INSTDIR\uninst.exe"
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\hiPodder.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\iPodder.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd

Function .onInit

  ReadRegStr $R0 HKLM \
  "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}" \
  "UninstallString"

  ReadRegStr $R2 HKLM \
  "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}" \
  "DisplayVersion"

FunctionEnd

Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) was successfully removed from your computer."
FunctionEnd

Function un.onInit
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Are you sure you want to completely remove $(^Name) and all of its components?" IDYES +2
  Abort
FunctionEnd

Section Uninstall

  Delete "$INSTDIR\plugins\description_links.py"
  Delete "$INSTDIR\favorites.txt"
  Delete "$INSTDIR\datetime.pyd"
  Delete "$INSTDIR\gpl.txt"
  Delete "$INSTDIR\hiPodder.exe"
  Delete "$INSTDIR\hiPodder.exe.manifest"
  Delete "$INSTDIR\library.zip"
  Delete "$INSTDIR\pyexpat.pyd"
  Delete "$INSTDIR\python23.dll"
  Delete "$INSTDIR\pythoncom23.dll"
  Delete "$INSTDIR\pywintypes23.dll"
  Delete "$INSTDIR\readme.txt"
  Delete "$INSTDIR\select.pyd"
  Delete "$INSTDIR\timer.pyd"
  Delete "$INSTDIR\unicodedata.pyd"
  Delete "$INSTDIR\w9xpopen.exe"
  Delete "$INSTDIR\win32api.pyd"
  Delete "$INSTDIR\win32evtlog.pyd"
  Delete "$INSTDIR\win32file.pyd"
  Delete "$INSTDIR\win32gui.pyd"
  Delete "$INSTDIR\win32pipe.pyd"
  Delete "$INSTDIR\win32ui.pyd"
  Delete "$INSTDIR\zlib.pyd"
  Delete "$INSTDIR\_bsddb.pyd"
  Delete "$INSTDIR\_socket.pyd"
  Delete "$INSTDIR\_sre.pyd"
  Delete "$INSTDIR\_ssl.pyd"
  Delete "$INSTDIR\_winreg.pyd"
  Delete "$INSTDIR\icons_status\hiPodder.ico"
  Delete "$INSTDIR\icons_status\hiPodder_running.ico"


  Delete "$SMPROGRAMS\hiPodder\Uninstall.lnk"
  Delete "$SMPROGRAMS\hiPodder\Website.lnk"
  Delete "$DESKTOP\hiPodder.lnk"
  Delete "$SMPROGRAMS\hiPodder\hiPodder.lnk"

  RMDir "$SMPROGRAMS\hiPodder"
  RMDir "$INSTDIR\icons_status"
  RMDir "$INSTDIR"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  SetAutoClose true
SectionEnd
