import os
ATTS = [
    ("STRIPE_ODD_COLOR",'#EDF3FE'),
    ("STRIPE_EVEN_COLOR",'#FFFFFF'),
    ("PRODUCT_NAME",'PodNova'),
    ("SCREEN_LANGUAGE", 'en'),
    ("CURRENT_VERSION_URL","http://www.podnova.com/podnova_client_current_version.xml"),        
    ("SPLASH_LIFETIME", 3000),
    ("SPLASH_DESTROY", True),
    ("DIRECTORY_LINK_SCANNED", '#7F007F'),
    ("DIRECTORY_LINK_UNSCANNED", '#00007F'),
    ("DIRECTORY_LINK_SCANNING", '#7F0000'),
    ("SEARCHBOXFEEDS_FG", None),
    ("SEARCHBOXFEEDS_BG", None),
    ("SUBSCTRL_FG", None),
    ("SUBSCTRL_BG", None),
    ("EPISODES_FG", None),
    ("EPISODES_BG", None),
    ("DOWNLOADS_FG", None),
    ("DOWNLOADS_BG", None),
    ("CLEANUP_FG", None),
    ("CLEANUP_BG", None),
    ("DIRECTORY_FG", None),
    ("DIRECTORY_BG", None),
    ("PRELOAD_SUBS", None),
    ]

#Look for a skin
import os,sys
basepath = os.path.abspath(os.path.split(sys.argv[0])[0])
skinspath = os.path.join(basepath,"gui","skins")
reskin = None
if os.path.exists(skinspath):
    for f in os.listdir(skinspath):
        if f.endswith(".zip"):
            #dead simple for now: use first zip file we find.
            sys.path.append(os.path.join(skinspath,f))
            reskin = __import__('reskin',globals(),locals(),[''])
            
for att in ATTS:
    if reskin and hasattr(reskin,att[0]):
        globals()[att[0]] = getattr(reskin,att[0])
    else:
        globals()[att[0]] = att[1]

if reskin and hasattr(reskin,"ATTS"):
    for att in reskin.ATTS:
        globals()[att] = getattr(reskin,att)

def set_skin_opts(gui):

    if SEARCHBOXFEEDS_FG:
        gui.searchboxfeeds.SetBackgroundColour(SEARCHBOXFEEDS_BG)
    if SEARCHBOXFEEDS_BG:
        gui.searchboxfeeds.SetForegroundColour(SEARCHBOXFEEDS_FG)

    if SUBSCTRL_BG:
        gui.feedslist.SetBackgroundColour(SUBSCTRL_BG)
    if SUBSCTRL_FG:
        gui.feedslist.SetForegroundColour(SUBSCTRL_FG)


    if EPISODES_BG:
        gui.episodes.SetBackgroundColour(EPISODES_BG)
    if EPISODES_FG:
        gui.episodes.SetForegroundColour(EPISODES_FG)

    if DOWNLOADS_BG:
        gui.downloads.SetBackgroundColour(DOWNLOADS_BG)
    if DOWNLOADS_FG:
        gui.downloads.SetForegroundColour(DOWNLOADS_FG)

    if CLEANUP_BG:
        gui.cleanupepisodes.SetBackgroundColour(CLEANUP_BG)
    if CLEANUP_FG:
        gui.cleanupepisodes.SetForegroundColour(CLEANUP_FG)

    if DIRECTORY_BG:
        gui.opmltree.SetBackgroundColour(DIRECTORY_BG)
    if DIRECTORY_FG:
        gui.opmltree.SetForegroundColour(DIRECTORY_FG)

